/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.common;

import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityLeaveWorldEvent;
import net.minecraftforge.event.entity.EntityMobGriefingEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.p3pp3rf1y.sophisticatedbackpacks.Config;
import net.p3pp3rf1y.sophisticatedbackpacks.SophisticatedBackpacks;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IAttackEntityResponseUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBlockClickResponseUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.common.EntityBackpackAdditionHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedbackpacks.network.AnotherPlayerBackpackOpenMessage;
import net.p3pp3rf1y.sophisticatedbackpacks.util.PlayerInventoryProvider;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.network.SyncPlayerSettingsMessage;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsManager;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.ServerStorageSoundHandler;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.RandHelper;

public class CommonEventHandler {
    private static final int BACKPACK_COUNT_CHECK_COOLDOWN = 40;
    private long nextBackpackCountCheck = 0L;

    public void registerHandlers() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModItems.registerHandlers(modBus);
        ModBlocks.registerHandlers(modBus);
        IEventBus eventBus = MinecraftForge.EVENT_BUS;
        eventBus.addListener(this::onItemPickup);
        eventBus.addListener(this::onLivingSpecialSpawn);
        eventBus.addListener(this::onLivingDrops);
        eventBus.addListener(this::onEntityMobGriefing);
        eventBus.addListener(this::onEntityLeaveWorld);
        eventBus.addListener(ServerStorageSoundHandler::tick);
        eventBus.addListener(this::onBlockClick);
        eventBus.addListener(this::onAttackEntity);
        eventBus.addListener(EntityBackpackAdditionHandler::onLivingUpdate);
        eventBus.addListener(this::onPlayerLoggedIn);
        eventBus.addListener(this::onPlayerChangedDimension);
        eventBus.addListener(this::onWorldTick);
        eventBus.addListener(this::interactWithEntity);
    }

    private void interactWithEntity(PlayerInteractEvent.EntityInteractSpecific event) {
        boolean isPointingAtBack;
        Player targetPlayer;
        block6: {
            block5: {
                Entity entity = event.getTarget();
                if (!(entity instanceof Player)) break block5;
                targetPlayer = (Player)entity;
                if (!Boolean.FALSE.equals(Config.COMMON.allowOpeningOtherPlayerBackpacks.get())) break block6;
            }
            return;
        }
        Player sourcePlayer = event.getPlayer();
        Vec3 targetPlayerViewVector = Vec3.m_82503_((Vec2)new Vec2(targetPlayer.m_146909_(), targetPlayer.f_20883_));
        Vec3 hitVector = event.getLocalPos();
        Vec3 vec31 = sourcePlayer.m_20182_().m_82505_(targetPlayer.m_20182_()).m_82541_();
        vec31 = new Vec3(vec31.f_82479_, 0.0, vec31.f_82481_);
        boolean isPointingAtBody = hitVector.f_82480_ >= 0.9 && hitVector.f_82480_ < 1.6;
        boolean bl = isPointingAtBack = vec31.m_82526_(targetPlayerViewVector) > 0.0;
        if (!isPointingAtBody || !isPointingAtBack) {
            return;
        }
        if (targetPlayer.f_19853_.f_46443_) {
            event.setCancellationResult(InteractionResult.SUCCESS);
            SophisticatedBackpacks.PACKET_HANDLER.sendToServer(new AnotherPlayerBackpackOpenMessage(targetPlayer.m_142049_()));
        }
    }

    private void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase != TickEvent.Phase.END || Boolean.FALSE.equals(Config.COMMON.nerfsConfig.tooManyBackpacksSlowness.get()) || this.nextBackpackCountCheck > event.world.m_46467_()) {
            return;
        }
        this.nextBackpackCountCheck = event.world.m_46467_() + 40L;
        event.world.m_6907_().forEach(player -> {
            AtomicInteger numberOfBackpacks = new AtomicInteger(0);
            PlayerInventoryProvider.get().runOnBackpacks((Player)player, (backpack, handlerName, identifier, slot) -> {
                numberOfBackpacks.incrementAndGet();
                return false;
            });
            int maxNumberOfBackpacks = (Integer)Config.COMMON.nerfsConfig.maxNumberOfBackpacks.get();
            if (numberOfBackpacks.get() > maxNumberOfBackpacks) {
                int numberOfSlownessLevels = Math.min(10, (int)Math.ceil((double)(numberOfBackpacks.get() - maxNumberOfBackpacks) * (Double)Config.COMMON.nerfsConfig.slownessLevelsPerAdditionalBackpack.get()));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 80, numberOfSlownessLevels - 1, false, false));
            }
        });
    }

    private void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        String playerTagName = "sophisticatedBackpackSettings";
        SophisticatedCore.PACKET_HANDLER.sendToClient((ServerPlayer)event.getPlayer(), (Object)new SyncPlayerSettingsMessage(playerTagName, SettingsManager.getPlayerSettingsTag((Player)event.getPlayer(), (String)playerTagName)));
    }

    private void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        String playerTagName = "sophisticatedBackpackSettings";
        SophisticatedCore.PACKET_HANDLER.sendToClient((ServerPlayer)event.getPlayer(), (Object)new SyncPlayerSettingsMessage(playerTagName, SettingsManager.getPlayerSettingsTag((Player)event.getPlayer(), (String)playerTagName)));
    }

    private void onBlockClick(PlayerInteractEvent.LeftClickBlock event) {
        if (event.getWorld().f_46443_) {
            return;
        }
        Player player = event.getPlayer();
        BlockPos pos = event.getPos();
        PlayerInventoryProvider.get().runOnBackpacks(player, (backpack, inventoryHandlerName, identifier, slot) -> backpack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).map(wrapper -> {
            for (IBlockClickResponseUpgrade upgrade : wrapper.getUpgradeHandler().getWrappersThatImplement(IBlockClickResponseUpgrade.class)) {
                if (!upgrade.onBlockClick(player, pos)) continue;
                return true;
            }
            return false;
        }).orElse(false));
    }

    private void onAttackEntity(AttackEntityEvent event) {
        Player player = event.getPlayer();
        if (player.f_19853_.f_46443_) {
            return;
        }
        PlayerInventoryProvider.get().runOnBackpacks(player, (backpack, inventoryHandlerName, identifier, slot) -> backpack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).map(wrapper -> {
            for (IAttackEntityResponseUpgrade upgrade : wrapper.getUpgradeHandler().getWrappersThatImplement(IAttackEntityResponseUpgrade.class)) {
                if (!upgrade.onAttackEntity(player)) continue;
                return true;
            }
            return false;
        }).orElse(false));
    }

    private void onLivingSpecialSpawn(LivingSpawnEvent.SpecialSpawn event) {
        Monster monster;
        Entity entity = event.getEntity();
        if (entity instanceof Monster && (monster = (Monster)entity).m_6844_(EquipmentSlot.CHEST).m_41619_()) {
            EntityBackpackAdditionHandler.addBackpack(monster);
        }
    }

    private void onLivingDrops(LivingDropsEvent event) {
        EntityBackpackAdditionHandler.handleBackpackDrop(event);
    }

    private void onEntityMobGriefing(EntityMobGriefingEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Creeper) {
            Creeper creeper = (Creeper)entity;
            EntityBackpackAdditionHandler.removeBeneficialEffects(creeper);
        }
    }

    private void onEntityLeaveWorld(EntityLeaveWorldEvent event) {
        if (!(event.getEntity() instanceof Monster)) {
            return;
        }
        EntityBackpackAdditionHandler.removeBackpackUuid((Monster)event.getEntity());
    }

    private void onItemPickup(EntityItemPickupEvent event) {
        ItemEntity itemEntity = event.getItem();
        if (itemEntity.m_32055_().m_41619_()) {
            return;
        }
        AtomicReference<ItemStack> remainingStackSimulated = new AtomicReference<ItemStack>(itemEntity.m_32055_().m_41777_());
        Player player = event.getPlayer();
        Level world = player.m_20193_();
        PlayerInventoryProvider.get().runOnBackpacks(player, (backpack, inventoryHandlerName, identifier, slot) -> backpack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).map(wrapper -> {
            remainingStackSimulated.set(InventoryHelper.runPickupOnPickupResponseUpgrades((Level)world, (UpgradeHandler)wrapper.getUpgradeHandler(), (ItemStack)((ItemStack)remainingStackSimulated.get()), (boolean)true));
            return ((ItemStack)remainingStackSimulated.get()).m_41619_();
        }).orElse(false), (Boolean)Config.COMMON.nerfsConfig.onlyWornBackpackTriggersUpgrades.get());
        if (remainingStackSimulated.get().m_41619_()) {
            ItemStack remainingStack = itemEntity.m_32055_().m_41777_();
            PlayerInventoryProvider.get().runOnBackpacks(player, (backpack, inventoryHandlerName, identifier, slot) -> backpack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).map(wrapper -> InventoryHelper.runPickupOnPickupResponseUpgrades((Level)world, (Player)player, (UpgradeHandler)wrapper.getUpgradeHandler(), (ItemStack)remainingStack, (boolean)false).m_41619_()).orElse(false), (Boolean)Config.COMMON.nerfsConfig.onlyWornBackpackTriggersUpgrades.get());
            if (!itemEntity.m_20067_()) {
                Random rand = itemEntity.f_19853_.f_46441_;
                itemEntity.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, (RandHelper.getRandomMinusOneToOne((Random)rand) * 0.7f + 1.0f) * 2.0f);
            }
            itemEntity.m_32045_(ItemStack.f_41583_);
            event.setCanceled(true);
        }
    }
}

